/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.emulated;

import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.Token;

public class ReaderItemView<TEx extends Exception>
extends SerializeReader.Delegating<TEx, ReaderItemView<TEx>> {
    private int depth = 0;
    private boolean began = false;

    public ReaderItemView(SerializeReader<TEx, ?> delegate) {
        super(delegate);
    }

    private void validateLegalBegin() throws TEx {
        if (this.depth - 1 >= this.nestingLimit) {
            throw this.createException("Nesting limit " + this.nestingLimit + " reached" + this.locationString());
        }
        if (!this.began) {
            this.began = true;
        } else if (this.depth == 0) {
            throw this.createException("View already exhausted");
        }
    }

    private void validateLegalEnd() throws TEx {
        if (!this.began) {
            throw this.createException("View not yet begun");
        }
        if (this.depth == 0) {
            throw this.createException("View already exhausted");
        }
    }

    @Override
    public ReaderItemView<TEx> beginArray() throws TEx {
        this.validateLegalBegin();
        this.delegate.beginArray();
        this.began = true;
        ++this.depth;
        return this;
    }

    @Override
    public ReaderItemView<TEx> endArray() throws TEx {
        this.validateLegalEnd();
        this.delegate.endArray();
        --this.depth;
        return this;
    }

    @Override
    public ReaderItemView<TEx> beginObject() throws TEx {
        this.validateLegalBegin();
        this.delegate.beginObject();
        this.began = true;
        ++this.depth;
        return this;
    }

    @Override
    public ReaderItemView<TEx> endObject() throws TEx {
        this.validateLegalEnd();
        this.delegate.endObject();
        --this.depth;
        return this;
    }

    @Override
    public boolean hasNext() throws TEx {
        return (!this.began || this.depth > 0) && this.delegate.hasNext();
    }

    @Override
    public Token peek() throws TEx {
        return this.began && this.depth == 0 ? Token.END_DOCUMENT : this.delegate.peek();
    }

    @Override
    public String nextName() throws TEx {
        this.validateLegalBegin();
        return this.delegate.nextName();
    }

    @Override
    public String nextString() throws TEx {
        this.validateLegalBegin();
        String s = this.delegate.nextString();
        this.began = true;
        return s;
    }

    @Override
    public boolean nextBoolean() throws TEx {
        this.validateLegalBegin();
        boolean b = this.delegate.nextBoolean();
        this.began = true;
        return b;
    }

    @Override
    public void nextNull() throws TEx {
        this.validateLegalBegin();
        this.delegate.nextNull();
        this.began = true;
    }

    @Override
    public double nextDouble() throws TEx {
        this.validateLegalBegin();
        double d = this.delegate.nextDouble();
        this.began = true;
        return d;
    }

    @Override
    public long nextLong() throws TEx {
        this.validateLegalBegin();
        long l = this.delegate.nextLong();
        this.began = true;
        return l;
    }

    @Override
    public int nextInt() throws TEx {
        this.validateLegalBegin();
        int i = this.delegate.nextInt();
        this.began = true;
        return i;
    }

    @Override
    public Number nextNumber() throws TEx {
        this.validateLegalBegin();
        Number n = this.delegate.nextNumber();
        this.began = true;
        return n;
    }

    @Override
    public void skipValue() throws TEx {
        this.validateLegalBegin();
        this.delegate.skipValue();
        this.began = true;
    }

    @Override
    public void close() throws TEx {
        if (!this.began) {
            this.skipValue();
            return;
        }
        while (this.depth > 0) {
            this.depth = switch (this.delegate.peek()) {
                default -> throw new MatchException(null, null);
                case Token.BEGIN_ARRAY, Token.BEGIN_OBJECT, Token.NULL, Token.BOOLEAN, Token.NUMBER, Token.STRING, Token.NAME -> {
                    this.delegate.skipValue();
                    yield this.depth;
                }
                case Token.END_ARRAY -> {
                    this.delegate.endArray();
                    yield this.depth - 1;
                }
                case Token.END_OBJECT -> {
                    this.delegate.endObject();
                    yield this.depth - 1;
                }
                case Token.END_DOCUMENT -> 0;
            };
        }
    }
}

